<?php

namespace App\Http\Controllers;

use App\Models\Cronogramas;
use App\Http\Controllers\Controller;
use App\Http\Requests\StoreCronogramasRequest;
use App\Http\Requests\UpdateCronogramasRequest;
use App\Imports\CronogramasImport;
use App\Models\inventario;
use App\Models\mantenimientos;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Http\Request;
use Illuminate\Http\JsonResponse;
use Maatwebsite\Excel\Facades\Excel;
use stdClass;

class CronogramasController extends Controller
{
    private $meses = array("enero", "febrero", "marzo", "abril", 'mayo', 'junio', 'julio', 'agosto', 'septiembre', 'octubre', 'noviembre', 'diciembre');

    /**
     * Display a listing of the resource.
     */
    public function index(Request $request)
    {
        $perPage = $request->input('per_page', 10);
        $cronos = Cronogramas::paginate($perPage);
        $cronos->getCollection()->transform(function ($crono) {
            $crono->inventario;
            $crono->mantenimientos;
            return $crono;
        });
        return response()->json($cronos, 200);
    }

    public function importData(Request $request): JsonResponse
    {
        if ($request->hasFile('excel')) {
            $array = Excel::toArray(new CronogramasImport, $request->file('excel'));
            $response = [];
            foreach ($array[0] as $element) {
                $cronos = new Cronogramas();
                $inventario = inventario::firstWhere('serie', $element['serie']);
                if ($inventario == NULL) {
                    $inventario = new stdClass();
                    $inventario->id = NULL;
                }

                $cronos->inventario_id = $inventario->id;
                $cronos->calibracion = $element['calibracion'];
                $cronos->frecuencia = $element['fecuencia'];
                $cronos->serie = $element['serie'];
                $cronos->instalacion = $element['fecha_instalacion'] ? Carbon::createFromFormat('d-m-Y', $element['fecha_instalacion']) : NULL;
                $cronos->responsable = $element['responsable'];
                $cronos->save();
                foreach ($this->meses as $value) {
                    if ($element[$value] !== '') {
                        $mantenimiento = new mantenimientos();
                        $mantenimiento->mes = $value;
                        $mantenimiento->year = $element['year'];
                        $mantenimiento->cronograma_id = $cronos['id'];
                        $mantenimiento->save();
                    }
                }
                $response[] = $cronos;
            }
            return response()->json($response, 200);
        }
        return response()->json(['message' => "No se encontro el archivo"], 404);
    }

    public function exportBase(Request $request)
    {
        return response()->streamDownload(function () {
    ob_end_clean(); // Elimina cualquier salida previa
    flush(); // Limpia el buffer de salida
    readfile(public_path('cargaArchivosMasivosCronos.xlsx'));
}, 'cargaArchivosMasivosCronos.xlsx', [
    'Content-Type' => 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'
]);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(StoreCronogramasRequest $request)
    {
        try {
            $cronos = new Cronogramas();
            $cronos->fill($request->all());
            $cronos->instalacion = Carbon::createFromFormat('d-m-Y', $cronos->instalacion);
            $cronos->saveOrFail();
            return response()->json(['message' => 'Cronograma agregado exitosamente', 'product' => $cronos], 201);
        } catch (ModelNotFoundException $exception) {
            return response()->json(['message' => $exception->getMessage()], 500);
        }
    }

    /**
     * Display the specified resource.
     */
    public function show(Cronogramas $cronograma)
    {
        $cronograma->inventario;
        $cronograma->mantenimientos;
        return response()->json($cronograma, 200);
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(Cronogramas $cronogramas)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(UpdateCronogramasRequest $request, Cronogramas $cronograma)
    {
        $cronograma->fill(attributes: $request->all());
        $cronograma->instalacion = Carbon::createFromFormat('d-m-Y', $cronograma->instalacion);
        if ($cronograma->save()) {
            return response()->json(['data' => $cronograma, 'message' => 'El cronograma se ha actualizado correctamente'], 200);
        }
        return response()->json(['data' => $cronograma, 'message' => 'Ha ocurrido un error al actualizar el cronograma'], 500);
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Cronogramas $cronograma)
    {
        $cronograma->delete();
        return response()->json(['data' => $cronograma, 'message' => 'El cronograma se ha eliminado correctamente'], 200);
    }
}
