<?php

namespace App\Http\Controllers;

use App\Models\mantenimientos;
use App\Http\Controllers\Controller;
use App\Http\Requests\StoremantenimientosRequest;
use App\Http\Requests\UpdatemantenimientosRequest;
use Illuminate\Database\Eloquent\ModelNotFoundException;

class MantenimientosController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $mantenimientos = mantenimientos::all();
        foreach ($mantenimientos as $mantenimiento) {
            $mantenimiento->cronograma->inventario;
        }
        return response()->json($mantenimientos, 200);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(StoremantenimientosRequest $request)
    {
        try {
            $mantenimiento = new mantenimientos();
            $mantenimiento->fill($request->all());
            $mantenimiento->saveOrFail();
            return response()->json(['message' => 'Mantenimiento agregado exitosamente', 'data' => $mantenimiento], 201);
        } catch (ModelNotFoundException $exception) {
            return response()->json(['message' => $exception->getMessage()], 500);
        }
    }

    /**
     * Display the specified resource.
     */
    public function show(mantenimientos $mantenimiento)
    {
        $mantenimiento->cronograma->inventario;
        return response()->json($mantenimiento, 200);
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(mantenimientos $mantenimiento)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(UpdatemantenimientosRequest $request, mantenimientos $mantenimiento)
    {
        $mantenimiento->fill($request->all());
        if ($mantenimiento->save()) {
            return response()->json(['data' => $mantenimiento, 'message' => 'El mantenimiento se ha actualizado correctamente'], 200);
        }
        return response()->json(['data' => $mantenimiento, 'message' => 'Ha ocurrido un error al actualizar el mantenimiento'], 500);
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(mantenimientos $mantenimiento)
    {
        $mantenimiento->delete();
        return response()->json(['data' => $mantenimiento, 'message' => 'El mantenimiento se ha eliminado correctamente'], 200);
    }
}
