<?php

namespace App\Http\Controllers;

use App\Models\subcategorias;
use App\Http\Controllers\Controller;
use App\Http\Requests\StoresubcategoriasRequest;
use App\Http\Requests\UpdatesubcategoriasRequest;
use Illuminate\Database\Eloquent\ModelNotFoundException;

class SubcategoriasController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index($categoria)
    {
        if($categoria == 'all'){
            $subcategorias = subcategorias::all();
        }else{
            $subcategorias = subcategorias::where('categoria_id', $categoria)->get();
        }
        return response()->json($subcategorias, 200);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(StoresubcategoriasRequest $request)
    {
        try {
            $subcategoria = new subcategorias();
            $subcategoria->fill($request->all());
            $subcategoria->saveOrFail();
            return response()->json(['message' => 'Categoria agregado exitosamente', 'product' => $subcategoria], 201);
        } catch (ModelNotFoundException $exception) {
            return response()->json(['message' => $exception->getMessage()], 500);
        }
    }

    /**
     * Display the specified resource.
     */
    public function show(subcategorias $subcategoria)
    {
        return response()->json($subcategoria, 200);
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(subcategorias $subcategorias)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(UpdatesubcategoriasRequest $request, subcategorias $subcategoria)
    {
        $subcategoria->fill($request->all());
        if ($subcategoria->save()) {
            return response()->json(['data' => $subcategoria, 'message' => 'La categoria se ha actualizado correctamente'], 200);
        }
        return response()->json(['data' => $subcategoria, 'message' => 'Ha ocurrido un error al actualizar la categoria'], 500);
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(subcategorias $subcategoria)
    {
        $subcategoria->delete();
        return response()->json(['data' => $subcategoria, 'message' => 'La categoria se ha eliminado correctamente'], 200);
    }
}
