<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('ginventarios', function (Blueprint $table) {
            $table->id();
            $table->string('dotacion')->nullable();
            $table->string('cantidad')->nullable();
            $table->string('qr')->nullable();
            $table->foreignId('subcategoria_id')
            ->references('id')
            ->on('gsubcategorias')
            ->onDelete('cascade');
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('ginventarios');
    }
};
